#include <bits/stdc++.h>

#define ll long long

struct Point
{
    ll x, h;
    ll index;
};

int main()
{
    ll n, it = 0;
    std::cin >> n;

    std::vector<Point> p(n);
    std::vector<ll> res(n, -1);

    for(ll i = 0; i < n; i++)
        std::cin >> p[i].x;
    for(ll i = 0; i < n; i++)
        std::cin >> p[i].h;

    for(ll i = 0; i < n; i++)
        p[i].index = i;

    std::sort(p.begin(), p.end(), [](const Point& a, const Point& b) {
        return a.x < b.x;
    });

    std::vector<ll> minl(n, 1e18), minr(n, 1e18);

    std::stack<ll> sl;
    for(ll i = 0; i < n; i++)
    {
        Point& p1 = p[i];

        while(!sl.empty())
        {
            Point& p2 = p[sl.top()];
            
            if(p1.h >= p2.h)
            {
                minl[p2.index] = (p1.x - p2.x) - (p1.h - p2.h);
                sl.pop();
            }
            else
                break;
        }

        sl.push(i);
    }

    std::stack<ll> sr;
    for(ll i = n - 1; i >= 0; i--)
    {
        Point& p1 = p[i];

        while(!sr.empty())
        {
            Point& p2 = p[sr.top()];
            
            if(p1.h >= p2.h)
            {
                minr[p2.index] = (p2.x - p1.x) - (p1.h - p2.h);
                sr.pop();
            }
            else
                break;
        }

        sr.push(i);
    }

    for(ll i = 0; i < n; i++)
    {
        res[i] = std::min(minl[i], minr[i]);
        if(res[i] == 1e18)
            res[i] = -1;
    }

    for(ll i = 0; i < n; i++)
        std::cout << res[i] << "\n";
    
    return 0;
}